# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 8
# Experiment: PMxPM, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR8_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR8(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Round 1: Defect to test opponent's response
    if current_round == 1:
        return "D"
    
    # Check for unconditional strategies in opponent's code
    if "always D" in opponent_program_code or "return 'D'" in opponent_program_code:
        return "D"
    if "always C" in opponent_program_code or "return 'C'" in opponent_program_code:
        return "D"
    
    # If opponent cooperated in Round 1, play Tit-for-Tat
    if opp_history[0] == "C":
        return opp_history[-1]
    
    # If opponent defected in Round 1, alternate between D and C starting with D
    if opp_history[0] == "D":
        if current_round % 2 == 0:
            return "D"
        else:
            return "C"
    
    # Default fallback: Tit-for-Tat
    return opp_history[-1] if opp_history else "D"